<?php
add_action('init', 'ninja_forms_register_tab_label_settings');

function ninja_forms_register_tab_label_settings(){
	$args = array(
		'name' => 'Labels', 
		'page' => 'ninja-forms-settings',
		'display_function' => '', 
		'save_function' => 'ninja_forms_save_label_settings',
	); 
	ninja_forms_register_tab('label_settings', $args);
	
}

add_action('init', 'ninja_forms_register_label_settings_metabox');

function ninja_forms_register_label_settings_metabox(){

	$args = array(
		'page' => 'ninja-forms-settings',
		'tab' => 'label_settings',
		'slug' => 'label_labels',
		'title' => __('Message Labels', 'ninja-forms'),
		'settings' => array(
			array(
				'name' => 'req_div_label',
				'type' => 'text',
				'label' => __('Required Field Label', 'ninja-forms'),
				'desc' => '',
				'help_text' => '',
			),
			array(
				'name' => 'req_field_symbol',
				'type' => 'text',
				'label' => __('Required field symbol', 'ninja-forms'),
			),
			/*		
			array(
				'name' => 'req_error_label',
				'type' => 'text',
				'label' => __('Error message given if all required fields are not completed', 'ninja-forms'),
			),
			*/
			array(
				'name' => 'req_field_error',
				'type' => 'text',
				'label' => __('Required Field Error', 'ninja-forms'),
				'desc' => '',
			),
			array(
			 	'name' => 'spam_error',
				'type' => 'text',
				'label' => __('Anti-spam error message', 'ninja-forms'),
				'desc' => '',
			),
			/*
			array(
				'name' => 'process_label',
				'type' => 'text',
				'label' => __('Ajax submitting message', 'ninja-forms'),
				'desc' => __('If your form is submitted via ajax, what message should appear to let users know it is being processed?', 'ninja-forms'),
			),
			*/
		),
	);
	ninja_forms_register_tab_metabox($args);
	
}

function ninja_forms_save_label_settings($data){
	$plugin_settings = get_option("ninja_forms_settings");
	foreach($data as $key => $val){
		$plugin_settings[$key] = $val;
	}
	update_option("ninja_forms_settings", $plugin_settings);
}