<?php
add_action( 'init', 'ninja_forms_register_tab_view_subs', 999 );
function ninja_forms_register_tab_view_subs(){
	$args = array(
		'name' => 'View Submissions', 
		'page' => 'ninja-forms-subs',
		'display_function' => 'ninja_forms_tab_view_subs', 
		'save_function' => 'ninja_forms_save_view_subs',
		'show_save' => false,
	); 
	ninja_forms_register_tab( 'view_subs', $args );
}

function ninja_forms_tab_view_subs(){
	global $ninja_forms_fields;
	$plugin_settings = get_option( 'ninja_forms_settings' );

	if( isset( $plugin_settings['date_format'] ) AND $plugin_settings['date_format'] != '' ){
		$date_format = $plugin_settings['date_format'];
	}else{
		$date_format = 'm/d/Y';
	}

	if( isset( $_REQUEST['form_id'] ) AND $_REQUEST['form_id'] == '' ){
		unset($_SESSION['ninja_forms_form_id']);
		$form_id = '';
	}else if( isset( $_REQUEST['form_id'] ) AND $_REQUEST['form_id'] != '' ){
		$_SESSION['ninja_forms_form_id'] = $_REQUEST['form_id'];
		$form_id = $_REQUEST['form_id'];
	}else if( isset( $_SESSION['ninja_forms_form_id']) AND $_SESSION['ninja_forms_form_id'] != 'all' ){
		$form_id = $_SESSION['ninja_forms_form_id'];
	}else{
		$form_id = '';
	}

	if( isset( $_REQUEST['sub_id'] ) AND !empty( $_REQUEST['sub_id'] ) ){
		$sub_id = $_REQUEST['sub_id'];
	}else{
		$sub_id = '';
	}

	if( isset( $_REQUEST['begin_date'] ) AND !empty( $_REQUEST['begin_date'] ) ){
		$begin_date = $_REQUEST['begin_date'];
	}else if( isset( $_SESSION['ninja_forms_begin_date'] ) AND !empty($_SESSION['ninja_forms_begin_date'] ) ){
		$begin_date = $_SESSION['ninja_forms_begin_date'];
	}else{
		$begin_date = '';
	}

	if(isset($_REQUEST['end_date']) AND !empty($_REQUEST['end_date'])){
		$end_date = $_REQUEST['end_date'];
	}else if(isset($_SESSION['ninja_forms_end_date']) AND !empty($_SESSION['ninja_forms_end_date'])){
		$end_date = $_SESSION['ninja_forms_end_date'];
	}else{
		$end_date = '';
	}

	if(isset($_REQUEST['edit_sub_form'])){
		$edit_sub_form = $_REQUEST['edit_sub_form'];
	}else{
		$edit_sub_form = '';
	}

	if($form_id == ''){
		?>
		<h2><?php _e('View Form Submissions', 'ninja-forms');?></h2>
		<p class="description description-wide">
			
		</p>
		<?php
	}else{
		$args = array(
			'form_id' => $form_id,
			'begin_date' => $begin_date,
			'end_date' => $end_date,
			//'status' => 1,
			//'11' => '05/06/2012',
		);
		$sub_results = ninja_forms_get_subs( $args );

		$sub_results = apply_filters( 'ninja_forms_view_subs_results', $sub_results );

		$sub_count = count( $sub_results );
		
		if( isset( $_REQUEST['limit'] ) ){
			$saved_limit = $_REQUEST['limit'];
			$limit = $_REQUEST['limit'];
		}else{
			$saved_limit = 20;
			$limit = 20;
		}

		if( $sub_count < $limit ){
			$limit = $sub_count;
		}

		if( isset( $_REQUEST['paged']) AND !empty( $_REQUEST['paged'] ) ){
			$current_page = $_REQUEST['paged'];
		}else{
			$current_page = 1;
		}

		if( $sub_count > $limit ){
			$page_count = ceil( $sub_count / $limit );
		}else{
			$page_count = 1;
		}

		if( $current_page > 1 ){
			$start = ( ( $current_page - 1 ) * $limit );
			if( $sub_count < $limit ){
				$end = $sub_count;
			}else{
				$end = $current_page * $limit;
				//$end = $end - 1;
			}

			if( $end > $sub_count ){
				$end = $sub_count;
			}
		}else{
			$start = 0;
			$end = $limit;
		}

		$form_row = ninja_forms_get_form_by_id($form_id);
		$form_title = '';
		if( is_array( $form_row ) AND !empty( $form_row ) ){
			if( isset( $form_row['data']['form_title'] ) ){
				$form_title = $form_row['data']['form_title'];
			}
		}
		

			if($edit_sub_form != 1){ 
			?>
			<div id="" class="tablenav top">
				<div class="alignleft actions">
				<select id="" class="" name="bulk_action">
					<option value=""><?php _e('Bulk Actions', 'ninja-forms');?></option>
					<option value="delete"><?php _e('Delete', 'ninja-forms');?></option>
					<option value="export"><?php _e('Export', 'ninja-forms');?></option>
				</select>
				<input type="submit" name="submit" value="Apply" class="button-secondary">
			</div>
			<div class="alignleft actions">
				<select id="" name="limit">
					<option value="20" <?php selected($saved_limit, 20);?>>20</option>
					<option value="50" <?php selected($saved_limit, 50);?>>50</option>
					<option value="100" <?php selected($saved_limit, 100);?>>100</option>
				</select>
				<?php _e('Submissions Per Page', 'ninja-forms');?>
				<input type="submit" name="submit" value="Go" class="button-secondary">
			</div>
				<div class="alignleft actions">
 					<input type="submit" name="submit" class="ninja-forms-download-all-subs button-secondary" value="<?php _e('Download All Submissions', 'ninja-forms');?>">
				</div>
				<div id="" class="alignright navtable-pages">
					<?php
					if($sub_count != 0 AND $current_page <= $page_count){
					?>
					<span class="displaying-num"><?php if($start == 0){ echo 1; }else{ echo $start + 1; }?> - <?php echo $end;?> of <?php echo $sub_count;?> <?php if($sub_count == 1){ _e('Submission', 'ninja-forms'); }else{ _e('Submissions', 'ninja-forms');}?></span>
					<?php
					}
						if($page_count > 1){

							$first_page = add_query_arg( array( 'paged' => 1 ) );
							$last_page = add_query_arg( array( 'paged' => $page_count ) );

							if($current_page > 1){
								$prev_page = $current_page - 1;
								$prev_page = add_query_arg( array( 'paged' => $prev_page ) );
							}else{
								$prev_page = $first_page;
							}
							if($current_page != $page_count){
								$next_page = $current_page + 1;
								$next_page = add_query_arg( array( 'paged' => $next_page ) );
							}else{
								$next_page = $last_page;
							}
							
					?>
					<span class="pagination-links">
						<a class="first-page disabled" title="Go to the first page" href="<?php echo $first_page;?>">«</a>
						<a class="prev-page disabled" title="Go to the previous page" href="<?php echo $prev_page;?>">‹</a>
						<span class="paging-input"><input class="current-page" title="Current page" type="text" name="paged" value="<?php echo $current_page;?>" size="2"> of <span class="total-pages"><?php echo $page_count;?></span></span>
						<a class="next-page" title="Go to the next page" href="<?php echo $next_page;?>">›</a>
						<a class="last-page" title="Go to the last page" href="<?php echo $last_page;?>">»</a>
					</span>
					<?php
						}
					?>
				</div>
			</div>
			<?php
			}else{
				$back_link = remove_query_arg(array('edit_sub_form'));
			?>
			<div id="" class="">
				<a href="<?php echo $back_link;?>"><input type="button" class="button-primary" value="Back To Sub List"></a>
			</div>
			<?php
			} 
			?>
			</div>			
			<table border="1px" class="wp-list-table widefat fixed posts">
			<?php
			//Grab the first few fields attached to our form so that we can create column headers.
			$field_results = ninja_forms_get_fields_by_form_id($form_id);
			$col_count = 0;
			if(is_array($field_results) AND !empty($field_results) AND $edit_sub_form != 1){
				foreach($field_results as $key => $field){
					$field_type = $field['type'];
					if( isset( $ninja_forms_fields[$field_type] ) ){
						$reg_field = $ninja_forms_fields[$field_type];
						if(!$reg_field['process_field'] OR !$reg_field['save_sub']){
							unset($field_results[$key]);
						}else{
							if($col_count < 2){
								$col_count++;
							}
						}
					}
				}
				
				$field_results = array_values($field_results);

				?>
				<thead>
					<tr>
						<th class="check-column"><input type="checkbox" id="" class="ninja-forms-select-all" title="ninja-forms-subs-bulk-action"></th>
						<th><?php _e('Date', 'ninja-forms');?></th>
				<?php
				$x = 0;
				while($x <= $col_count){
					if(isset($field_results[$x]['data']['label'])){
		
				?>
						<th><?php echo $field_results[$x]['data']['label'];?></th>
				<?php
					}
					$x++;			
				}
				?>	
					</tr>
				</thead>
		<?php
			}
		?>
				<tbody id="ninja_forms_subs_tbody">
		<?php
		if( is_array( $sub_results ) AND !empty( $sub_results ) AND $edit_sub_form != 1 AND $current_page <= $page_count ){

			for ($i = $start; $i < $end; $i++) {
				$sub = $sub_results[$i];
				$data = $sub['data'];
				
				$download_link = add_query_arg(array('ninja_forms_export_subs_to_csv' => 1, 'sub_id' => $sub['id'], 'form_id' => $form_id));
				$edit_link = add_query_arg(array('edit_sub_form' => 1, 'sub_id' => $sub['id'], 'form_id' => $form_id));
				?>
				<tr id="ninja_forms_sub_<?php echo $sub['id'];?>_tr">
					<th scope="row" class="check-column">
						<input type="checkbox" id="" name="ninja_forms_sub[]" value="<?php echo $sub['id'];?>" class="ninja-forms-subs-bulk-action">
					</th>
					<td>
						<?php
							$date = $sub['date_updated'];
							$date = strtotime($date);
							$date = date($date_format, $date);
							echo $date;
						?>
						<div class="row-actions">
							<span class="edit"><a href="<?php echo $edit_link;?>" id="ninja_forms_sub_<?php echo $sub['id'];?>" class="ninja-forms-view-sub"><?php _e('Edit', 'ninja-forms');?></a> | </span>
							<span class="trash"><a href="#" id="ninja_forms_sub_<?php echo $sub['id'];?>" class="ninja-forms-delete-sub"><?php _e('Delete', 'ninja-forms');?></a> | </span>
							<span class="export"><a href="<?php echo $download_link;?>" id="ninja_forms_sub_<?php echo $sub['id'];?>" class="ninja-forms-export-sub"><?php _e('Export to CSV', 'ninja-forms');?></a></span>

						</div>
					</td>
				<?php
					$x = 0;
					while($x <= $col_count){
						if(isset($field_results[$x]['id'])){
						$field_id = $field_results[$x]['id'];
					?>

						<td id="ninja_forms_sub_<?php echo $sub['id'];?>_field_<?php echo $field_id;?>">
						<?php
							foreach($data as $d){
								if($field_id == $d['field_id']){
									$user_value = ninja_forms_stripslashes_deep($d['user_value']);
									$user_value = ninja_forms_strip_tags_deep($user_value);
									$user_value = apply_filters('ninja_forms_view_sub_td', $user_value, $d['field_id']);
									if(is_array($user_value) AND !empty($user_value)){
										$y = 1;
										foreach($user_value as $val){
											echo stripslashes($val);
											if($y != count($user_value)){
												echo ",";
											}
											$y++;
										}
									}else{
										echo stripslashes($user_value);
									}
								}
							}
						?>
						</td>
					<?php
						}
						$x++;	
					}
				?>
					
				</tr>
				<?php
			}
		}else if($edit_sub_form == 1){
			$sub_row = ninja_forms_get_sub_by_id($sub_id);
			$data = $sub_row['data'];
			$date_updated = strtotime($sub_row['date_updated']);
			$date_updated = date($date_format, $date_updated);
			$sub_status = $sub_row['status'];
			

			?>
				<input type="hidden" name="_sub_id" value="<?php echo $sub_id;?>">
				<input type="hidden" name="_ninja_forms_edit_sub" value="1">
				<input type="hidden" name="_ninja_forms_sub_status" value="<?php echo $sub_status;?>">
				<input type="hidden" name="_form_id" value="<?php echo $form_id;?>">
				<?php

				add_filter('ninja_forms_field', 'ninja_forms_edit_sub_default_value', 99, 2);
				add_filter('ninja_forms_field', 'ninja_forms_edit_sub_hide_fields', 99, 2);
				remove_action('ninja_forms_display_before_fields', 'ninja_forms_display_req_items');
				remove_action('ninja_forms_display_open_form_tag', 'ninja_forms_display_open_form_tag');
				remove_action('ninja_forms_display_close_form_tag', 'ninja_forms_display_close_form_tag');
				remove_action('ninja_forms_display_after_open_form_tag', 'ninja_forms_display_hidden_fields');
				ninja_forms_display_form($form_id);
				?>
				<tr id="">
					<td colspan="2"><input type="submit" name="submit" value="Save Sub" class="button-secondary"></td>
				</tr>
			<?php
		}else{
			?>
			<tr id="ninja_forms_subs_empty" style="">
				<td colspan="7">
					<?php _e("No submissions found", "ninja-forms");?>
				</td>
			</tr>
			<?php
		}
			?>
			
				</tbody>
				<?php
			//Grab the first few fields attached to our form so that we can create column headers.
				
			//$field_results = ninja_forms_get_fields_by_form_id($form_id);
			//$col_count = 0;
			if(is_array($field_results) AND !empty($field_results) AND $edit_sub_form != 1){
			/*
				foreach($field_results as $key => $field){
					$field_type = $field['type'];
					$reg_field = $ninja_forms_fields[$field_type];
					if(!$reg_field['process_field'] OR !$reg_field['save_sub']){
						unset($field_results[$key]);
					}else{
						if($col_count < 2){
							$col_count++;
						}
					}
				}
			
				*/
				?>
				<tfoot>
					<tr>
						<th class="check-column"><input type="checkbox" id="" class="ninja-forms-select-all" title="ninja-forms-subs-bulk-action"></th>
						<th><?php _e('Date', 'ninja-forms');?></th>
				<?php
				$x = 0;
				while($x <= $col_count){
					if(isset($field_results[$x]['data']['label'])){
				?>
						<th><?php echo $field_results[$x]['data']['label'];?></th>
				<?php
					}
					$x++;			
				}
				?>	
					</tr>
				</tfoot>
		<?php
			}
			?>
			</table>
		<div id="ninja_forms_sub_info_wrap" class="form-section" style="display:none;">
			<a href="#" id="" class="ninja-forms-back-sub"><?php _e('Back', 'ninja-forms');?></a>
			<br />
			<br />
			<div id="ninja_forms_sub_info">
			
			
			</div>
			<input type="button" id="ninja_forms_edit_sub" value="Save" class="button-primary"> &nbsp;&nbsp; <span id="ninja_forms_edit_sub_loading" style="display:none;"><img src="<?php echo NINJA_FORMS_URL."/images/loading.gif";?>"></span>
		</div>
			<?php
	
	}
}

if(isset($_POST['_ninja_forms_edit_sub']) AND $_POST['_ninja_forms_edit_sub'] == 1){
	add_action( 'init', 'ninja_forms_setup_processing_class', 5 );
	add_action( 'init', 'ninja_forms_set_save_sub' );
	add_action( 'init', 'ninja_forms_edit_sub_pre_process', 999 );
}

function ninja_forms_edit_sub_pre_process(){
	global $ninja_forms_processing;
	do_action( 'ninja_forms_edit_sub_pre_process' );
	if( !$ninja_forms_processing->get_all_errors() ){
		ninja_forms_edit_sub_process();
	}
}

function ninja_forms_edit_sub_process(){
	global $ninja_forms_processing;
	do_action( 'ninja_forms_edit_sub_process' );
	if( !$ninja_forms_processing->get_all_errors() ){
		ninja_forms_edit_sub_post_process();
	}
}

function ninja_forms_edit_sub_post_process(){
	global $ninja_forms_processing;
	do_action( 'ninja_forms_edit_sub_post_process' );
}

add_action( 'init', 'ninja_forms_register_edit_sub_save_values' );
function ninja_forms_register_edit_sub_save_values(){
	add_action( 'ninja_forms_edit_sub_post_process', 'ninja_forms_edit_sub_save_values' );
}

function ninja_forms_edit_sub_save_values(){
	global $ninja_forms_processing;

	$sub_id = $ninja_forms_processing->get_form_setting( 'sub_id' );
	$form_id = $ninja_forms_processing->get_form_ID();
	$user_id = $ninja_forms_processing->get_user_ID();

	$sub_row = ninja_forms_get_sub_by_id( $sub_id );
	$status = $sub_row['status'];

	
	$action = $sub_row['action'];

	$field_data = $ninja_forms_processing->get_all_fields();
	$sub_data = array();

	if(is_array($field_data) AND !empty($field_data)){
		foreach($field_data as $field_id => $user_value){
			array_push( $sub_data, array( 'field_id' => $field_id, 'user_value' => $user_value ) );
		}
	}

	$args = array(
		'form_id' => $form_id,
		'user_id' => $user_id,
		'status' => $status,
		'action' => $action,
		'data' => serialize( $sub_data ),
		'sub_id' => $sub_id,
	);

	$args = apply_filters( 'ninja_forms_edit_sub_args', $args );

	ninja_forms_update_sub($args);
}

function ninja_forms_save_view_subs($form_id, $data){
	global $ninja_forms_admin_update_message;
	$plugin_settings = get_option("ninja_forms_settings");
	if( isset( $_POST['submit'] ) AND $_REQUEST['page'] == 'ninja-forms-subs' ){
		switch( $_POST['submit'] ){
			case __( 'Apply', 'ninja-forms' ):
				if( isset( $_POST['bulk_action'] ) ){
					if( $_POST['bulk_action'] == 'delete' ){
						if( isset( $_POST['ninja_forms_sub'] ) AND is_array( $_POST['ninja_forms_sub'] ) AND !empty( $_POST['ninja_forms_sub'] ) ){
							foreach( $_POST['ninja_forms_sub'] as $sub_id ){
								ninja_forms_delete_sub($sub_id);
							}

							$ninja_forms_admin_update_message = count( $_POST['ninja_forms_sub'] ).' ';

							if( count( $_POST['ninja_forms_sub'] ) > 1 ){
								$ninja_forms_admin_update_message .= __( 'Submissions Deleted', 'ninja-forms' );
							}else{
								$ninja_forms_admin_update_message .= __( 'Submission Deleted', 'ninja-forms' );
							}
						}
					}elseif( $_POST['bulk_action'] == 'export' ){
						if( isset($_POST['ninja_forms_sub'] ) AND is_array( $_POST['ninja_forms_sub'] ) AND !empty( $_POST['ninja_forms_sub'] ) ){
							ninja_forms_export_subs_to_csv( $_POST['ninja_forms_sub'] );	
						}
					}
				}
				break;
			case __( 'Download All Submissions', 'ninja-forms' ):
					
				if( isset( $plugin_settings['date_format'] ) AND $plugin_settings['date_format'] != '' ){
					$date_format = $plugin_settings['date_format'];
				}else{
					$date_format = 'm/d/Y';
				}
				if( isset( $_REQUEST['form_id'] ) AND !empty( $_REQUEST['form_id'] ) ){
					$form_id = $_REQUEST['form_id'];
				}else{
					$form_id = '';
				}
				
				if( isset( $_REQUEST['ninja_forms_begin_date'] ) AND !empty( $_REQUEST['ninja_forms_begin_date'] ) ){
					$begin_date = $_REQUEST['ninja_forms_begin_date'];
				}else{
					$begin_date = '';
				}
				
				if( isset( $_REQUEST['ninja_forms_end_date'] ) AND !empty( $_REQUEST['ninja_forms_end_date'] ) ){
					$end_date = $_REQUEST['ninja_forms_end_date'];
				}else{
					$end_date = '';
				}
				$args = array(
					'form_id' => $form_id,
					'begin_date' => $begin_date,
					'end_date' => $end_date,
					//'status' => 1,
					//'4' => 'unchecked',
				);
				$sub_results = ninja_forms_get_subs($args);
				$sub_results = apply_filters( 'ninja_forms_download_all_subs_results', $sub_results );
				if(is_array($sub_results) AND !empty($sub_results)){
					$sub_ids = array();
					foreach($sub_results as $sub){
						$sub_ids[] = $sub['id'];
					}
					ninja_forms_export_subs_to_csv($sub_ids);
				}
				break;
			case __('Save Sub', 'ninja-forms'):
				break;
			case __('View Submissions', 'ninja-forms'):
				break;
		}
	}
}

function ninja_forms_set_save_sub(){
	global $ninja_forms_processing;
	$ninja_forms_processing->update_form_setting( 'sub_id', $_REQUEST['_sub_id'] );
	$ninja_forms_processing->set_action( 'edit_sub' );
}

function ninja_forms_edit_sub_default_value($data, $field_id){
	$sub_id = $_REQUEST['sub_id'];
	$sub_row = ninja_forms_get_sub_by_id($sub_id);
	$sub_data = $sub_row['data'];
	if(is_array($sub_data) AND !empty($sub_data)){
		foreach($sub_data as $d){
			if($d['field_id'] == $field_id){
				$data['default_value'] = $d['user_value'];
			}
		}
	}

	return $data;
}

function ninja_forms_edit_sub_hide_fields($data, $field_id){
	global $ninja_forms_fields;
	$field_row = ninja_forms_get_field_by_id($field_id);
	$field_data = $field_row['data'];
	$field_type = $field_row['type'];
	$type = $ninja_forms_fields[$field_type];
	$process_field = $type['process_field'];
	if(!$process_field){
		$data['show_field'] = false;
	}
	return $data;
}