<?php
// This file generates the CSS overrides from the admin interface. It will be included only
// when needed.
function weaverii_save_current_css() {
    // write the current generated CSS to a file - called only from Weaver II Admin

    if (!weaverii_f_file_access_available() || !current_user_can( 'manage_options' ) ) {
	return '';
    }

    $save_dir = weaverii_f_uploads_base_dir() . 'weaverii-subthemes';
    $save_url = weaverii_f_uploads_base_url() . 'weaverii-subthemes';

    $usename = 'style-weaverii.css';

    $wii_theme_dir_exists = weaverii_f_mkdir($save_dir);
    if (!$wii_theme_dir_exists) {
	weaverii_f_file_access_fail('Unable to create directory. Probably a file system permission problem. Directory' . $save_dir);
    }
    $wii_theme_dir_writable = $wii_theme_dir_exists;

   if (!weaverii_f_is_writable($save_dir)) {
	weaverii_f_file_access_fail('Directory not writable. Probably a file system permission problem. Directory: ' . $save_dir);
        $wii_theme_dir_writable = false;
    }

    $filename = $save_dir . '/'. $usename;    // we will add txt

    if (!$wii_theme_dir_writable || !$wii_theme_dir_exists || !($handle = weaverii_f_open($filename, 'w')) ) {
	weaverii_f_file_access_fail('Unable to create file. Probably a file system permission problem. File: ' . $filename);
	return '';
    }

    weaverii_f_write($handle,sprintf("/* WARNING: Do not edit this file. It is dynamically generated. Any edits you make will be overwritten. */
/* This file generated using %s %s subtheme: %s */\n",WEAVERII_THEMENAME, WEAVERII_VERSION, weaverii_getopt('wii_subtheme')));

    weaverii_output_style($handle);
    if (!weaverii_f_close($handle)) {
	weaverii_f_file_access_fail('Unable to create file. Probably a file system permission problem. File: ' . $filename);
	return '';
    }

    return $save_url . '/' . $usename;
}

function weaverii_output_style($sout) {
    /* This outputs the CSS overrides. It will output to a file pointer, so it can write to a .css file saved
       in the user's upload directory - just like the saved style .wvr files. It is included via a standard
       css include. It needs to be loaded only for the admin page.
    */
    weaverii_f_write($sout,sprintf("/* Weaver II styles - Version %s */\n",weaverii_getopt('wii_style_version')));


// =========================== LINKS ===============================
//	Important. Links must come before any other rules that might define a - such as the menu bars, so just
//	put them here, near the top.

    weaverii_put_link($sout,'wii_link','a', 'a:visited', 'a:hover');
    weaverii_put_link($sout,'wii_plink','.entry-title a', '.entry-title a:visited', '.entry-title a:hover');
    weaverii_put_link($sout,'wii_ilink','.entry-meta a, .entry-utility a', '.entry-meta a:visited, .entry-utility a:visited',
	'.entry-meta a:hover, .entry-utility a:hover');
    weaverii_put_link($sout,'wii_wlink','.widget-area a', '.widget-area a:visited', '.widget-area a:hover');
    weaverii_put_link($sout,'wii_ibarlink','#infobar a', '#infobar a:visited', '#infobar a:hover');
    weaverii_put_link($sout,'wii_footerlink','#colophon a', '#colophon a:visited', '#colophon a:hover');



// ========================= GENERAL APPEARANCE ===============================

   /*  wii_useborders  */
    $b_c = weaverii_getopt('wii_border_color');	//+
    if (!$b_c) $b_c = '#222';
    $b_w = weaverii_getopt('wii_border_width_int'); //+
    if (!$b_w) $b_w = 1;
    $b_s = weaverii_getopt('wii_border_style'); //+
    if (!$b_s) $b_s = 'solid';

    if (weaverii_getopt_checked('wii_useborders') || weaverii_getopt_checked('wii_wrapper_border')) {
        weaverii_f_write($sout, sprintf("#wrapper {border: %dpx %s %s;}\n",$b_w, $b_s, $b_c));
    }
    if (weaverii_getopt_checked('wii_useborders')) {
	/* we need to use each widget area explicitly instead of simply .widget-area so the PIE works right on IE */
	weaverii_f_write($sout, sprintf("#sidebar_primary,#sidebar_right,#sidebar_left,.sidebar_top,.sidebar_bottom,.sidebar_extra,#first,#second,#third,#fourth, .mobile_widget_area {border: %dpx %s %s;}\n",$b_w, $b_s, $b_c));
    }

    /*  wii_rounded_corners  */
    $r = 10;
    $rm = 7;

    $newr = weaverii_getopt('wii_rounded_corners_radius');
    if ($newr) {
	$r = $newr;
	if ($r >= 8)
	    $rm = (int)(.7 * $r);
	else
	    $rm = $r;
    }

    if (weaverii_getopt('wii_rounded_corners')) { // not #access3
        weaverii_f_write($sout, sprintf("#wrapper, #branding, #colophon, .commentlist li.comment, #respond, #sidebar_primary,#sidebar_right,#sidebar_left,.sidebar_top,.sidebar_bottom,.sidebar_extra,#first,#second,#third,#fourth,.mobile_widget_area {-moz-border-radius: %dpx; -webkit-border-radius: %dpx; border-radius: %dpx;}\n",$r,$r,$r));
	weaverii_f_write($sout, sprintf("#sidebar_wrap_right.right-1-col,#sidebar_wrap_right.right-2-col,#sidebar_wrap_right.right-2-col-bottom,
#sidebar_wrap_left.left-1-col,#sidebar_wrap_left.left-2-col,#sidebar_wrap_left.left-2-col-bottom,#sidebar_wrap_left,#sidebar_wrap_right
{-moz-border-radius: %dpx; -webkit-border-radius: %dpx; border-radius: %dpx;}\n",$r,$r,$r));

	weaverii_f_write($sout, sprintf(".commentlist li.comment .comment-meta {-moz-border-radius-topleft: %dpx; -moz-border-radius-topright: %dpx;
 -webkit-border-top-left-radius: %dpx; -webkit-border-top-right-radius: %dpx; border-top-left-radius: %dpx; border-top-right-radius: %dpx;}\n",
	$rm,$rm,$rm,$rm,$rm,$rm));

	if (weaverii_getopt('wii_move_menu')) {
	    weaverii_f_write($sout, sprintf("#access2 {-moz-border-radius-bottomleft: %dpx; -moz-border-radius-bottomright: %dpx;
 -webkit-border-bottom-left-radius: %dpx; -webkit-border-bottom-right-radius: %dpx; border-bottom-left-radius: %dpx; border-bottom-right-radius: %dpx;}\n",
    $rm,$rm,$rm,$rm,$rm,$rm));
	    weaverii_f_write($sout, sprintf("#access {-moz-border-radius-topleft: %dpx; -moz-border-radius-topright: %dpx;
 -webkit-border-top-left-radius: %dpx; -webkit-border-top-right-radius: %dpx; border-top-left-radius: %dpx; border-top-right-radius: %dpx;}\n",
	$rm,$rm,$rm,$rm,$rm,$rm));
	} else {
	    weaverii_f_write($sout, sprintf("#access {-moz-border-radius-bottomleft: %dpx; -moz-border-radius-bottomright: %dpx;
 -webkit-border-bottom-left-radius: %dpx; -webkit-border-bottom-right-radius: %dpx;border-bottom-left-radius: %dpx; border-bottom-right-radius: %dpx;}\n",
	$rm,$rm,$rm,$rm,$rm,$rm));
	    weaverii_f_write($sout, sprintf("#access2 {-moz-border-radius-topleft: %dpx; -moz-border-radius-topright: %dpx;
 -webkit-border-top-left-radius: %dpx; -webkit-border-top-right-radius: %dpx;border-top-left-radius: %dpx; border-top-right-radius: %dpx;}\n",
	$rm,$rm,$rm,$rm,$rm,$rm));
	}
    }
    if (weaverii_getopt('wii_rounded_corners_content')) { // content area, too
        weaverii_f_write($sout, sprintf("#content, #content .post{-moz-border-radius: %dpx; -webkit-border-radius: %dpx; border-radius: %dpx;}\n",$r,$r,$r));
    }

    /*  wii_fadebody_bg  */

    if (weaverii_getopt('wii_fadebody_bg')) {
	weaverii_f_write($sout, sprintf("body {background-image: url(%s); background-attachment: scroll; background-repeat: repeat-x;}\n",
	       weaverii_relative_url('images/gr.png')));
    }

    /*  wii_wrap_shadow  */
    if (weaverii_getopt('wii_wrap_shadow')) {
	weaverii_f_write($sout, sprintf("#wrapper {-webkit-box-shadow: 0 0 3px 3px rgba(0,0,0,0.25); -moz-box-shadow: 0 0 3px 3px rgba(0,0,0,0.25); box-shadow: 0 0 3px 3px rgba(127,127,127,0.25);}\n"));
    }


// ========================= LAYOUT / SIDEBAR AREAS ===============================

    $themew = weaverii_getopt('wii_theme_width_int');
    if (!$themew) $themew = 940;	// nothing will work right if this doesn't have a value
    $wrap_pad = weaverii_getopt('wii_wrapper_padding');
    if ($wrap_pad == '') $wrap_pad = 10;
    if (weaverii_getopt_checked('wii_theme_width_fixed')) {
    	weaverii_f_write($sout,sprintf("#wrapper{max-width:%dpx;width:%dpx;}\n",$themew,$themew));
	if (weaverii_getopt_checked('wii_top_menu_before_wrapper'))
	    weaverii_f_write($sout,sprintf("#nav-top-menu{margin:auto;width:%dpx;}\n",$themew+(2*$wrap_pad)));
    } else {
	weaverii_f_write($sout,sprintf("#wrapper{max-width:%dpx;}\n",$themew));
	if (weaverii_getopt_checked('wii_top_menu_before_wrapper'))
	    weaverii_f_write($sout,sprintf("#nav-top-menu{margin:auto;max-width:%dpx;}\n",$themew+(2*$wrap_pad)));
    }


    weaverii_css_style_val($sout, '#wrapper', '{padding: %dpx;}',
			   'wii_wrapper_padding'); // wrapper padding

    $sb_areas = array ('primary' => '#sidebar_primary,.mobile_widget_area', 'right' => '#sidebar_right', 'left' => '#sidebar_left',
	'top' => '.sidebar_top', 'bottom' => '.sidebar_bottom',
	'footer' => '#first,#second,#third,#fourth', 'widget'=>'.widget');
    /* _bgcolor,  _margin_T, _margin_B, _std_border */

    foreach ($sb_areas as $area => $tag) {
	$id = 'wii_widget_' . $area;
	if ($tag == '.sidebar_top') $tag .= ',.sidebar_extra';	// extra rule for extra sidebar

	weaverii_put_bgcolor($sout, $id . '_bgcolor', $tag);
	$mt = weaverii_getopt($id . '_margin_T');
	$mb = weaverii_getopt($id . '_margin_B');
	// make each separate because might not want to override defaults
	$rule = '';
	$rule .= $mt ? 'margin-top:' . $mt . 'px;' : '';
	$rule .= $mb ? 'margin-bottom:' . $mb . 'px;' : '';
	if ($rule) {
	    weaverii_f_write($sout, $tag . '{' . $rule . "}\n");
	}
	if (weaverii_getopt_checked($id . '_std_border')) {
	    if (!weaverii_getopt_checked('wii_useborders') || $tag == '.widget')
		weaverii_f_write($sout, sprintf("%s {border: %dpx %s %s;}\n",$tag,$b_w, $b_s, $b_c));
	}
    }

    // 'wii_widget_top_indent_int', bottom
    if (($val = weaverii_getopt('wii_widget_top_indent_int')) != '') {
	weaverii_f_write($sout, sprintf(".sidebar_top,.sidebar_extra {margin-left: %.3f%%;margin-right: %.3f%%;}\n", $val,$val));
    }
    if (($val = weaverii_getopt('wii_widget_bottom_indent_int')) != '') {
	weaverii_f_write($sout, sprintf(".sidebar_bottom {margin-left: %.3f%%;margin-right: %.3f%%;}\n", $val,$val));
    }

    // widget areas and widget margins interact - need to adjust depending on what widget margin are

    $ww_mtop = weaverii_getopt('wii_widget_widget_margin_T');
    $ww_mbot = weaverii_getopt('wii_widget_widget_margin_B');
    $w_pad = weaverii_getopt("wii_widget_padding_int");

    if ($w_pad || $ww_mtop || $ww_mbot) {	// either set top val or need to adjust
	$wmbot = $ww_mbot ? $ww_mbot : '10';

	if ($w_pad == '') $w_pad = '10';
	$t = '0'; $b = '0';
	if ($w_pad != '0') {
	    $t = $w_pad - $ww_mtop;
	    if ($t < 0) $t = '0';
	    $b = $w_pad - $wmbot;
	    if ($b < 0) $b = '0';
	}
	weaverii_f_write($sout, sprintf(".widget-area {padding: %dpx %dpx %dpx %dpx;}\n", $t,$w_pad,$b,$w_pad));
    }


    if ($ww_mtop && $ww_mbot) {	// combine?
	weaverii_f_write($sout, sprintf(".widget {margin-bottom: %dpx;margin-top: %dpx;}\n", $ww_mbot,$ww_top));
    } else {
	if ($ww_mtop != '') weaverii_f_write($sout, sprintf(".widget {margin-top: %dpx;}\n", $ww_top));
	if ($ww_mbot != '') weaverii_f_write($sout, sprintf(".widget {margin-bottom: %dpx;}\n", $ww_mbot));
    }

// 'wii_widget_widget_padding_int'
    weaverii_css_style_val($sout, '.widget', '{padding: %dpx;}', 'wii_widget_widget_padding_int');

// The widths: 'wii_theme_width_int' 'sb_right_2_col_width_int' 'sb_left_1_col_width_int' 'sb_left_2_col_width_int'
// 'sb_split_left_width_int' 'sb_split_right_width_int' 'sb_2_left_area_int'

    $sbw = weaverii_getopt('sb_default_width_int');
    $cw = 100;	// maybe add content width option in the future.
    if ($sbw != '') {
	$sbwl = $sbw; $sbwr = $sbw;
	weaverii_f_write($sout,
	    sprintf("#container_wrap.right-1-col{width:%.3f%%;} #sidebar_wrap_right.right-1-col{width:%.3f%%;} \n",$cw-$sbw,$sbw));
	weaverii_f_write($sout,
	    sprintf("#container_wrap.right-2-col, #container_wrap.right-2-col-bottom{width:%.3f%%;} #sidebar_wrap_right.right-2-col, #sidebar_wrap_right.right-2-col-bottom{width:%.3f%%;}\n",$cw-$sbw,$sbw));
	weaverii_f_write($sout,
	    sprintf("#container_wrap.left-1-col{width:%.3f%%;} #sidebar_wrap_left.left-1-col{width:%.3f%%;}\n",$cw-$sbw,$sbw));
	weaverii_f_write($sout,
	    sprintf("#container_wrap.left-2-col, #container_wrap.left-2-col-bottom{width:%.3f%%;} #sidebar_wrap_left.left-2-col,#sidebar_wrap_left.left-2-col-bottom{width:%.3f%%;}\n",$cw-$sbw,$sbw));
	weaverii_f_write($sout,
	    sprintf("#container_wrap{width:%.3f%%;} #sidebar_wrap_left{width:%.3f%%;} #sidebar_wrap_right{width:%.3f%%;}\n",
	    $cw-$sbwl-$sbwr,$sbwl,$sbwr));
    } else {

    $sbw = weaverii_getopt('sb_right_1_col_width_int');	//+ ALL
    if ($sbw) {
	weaverii_f_write($sout,
	    sprintf("#container_wrap.right-1-col{width:%.3f%%;} #sidebar_wrap_right.right-1-col{width:%.3f%%;}\n",$cw-$sbw,$sbw));
    }
    $sbw = weaverii_getopt('sb_right_2_col_width_int');
    if ($sbw != '') {
	weaverii_f_write($sout,
	    sprintf("#container_wrap.right-2-col,#container_wrap.right-2-col-bottom{width:%.3f%%;} #sidebar_wrap_right.right-2-col,#sidebar_wrap_right.right-2-col-bottom{width:%.3f%%;}\n",$cw-$sbw,$sbw));
    }
    $sbw = weaverii_getopt('sb_left_1_col_width_int');
    if ($sbw != '') {
	weaverii_f_write($sout,
	    sprintf("#container_wrap.left-1-col{width:%.3f%%;} #sidebar_wrap_left.left-1-col{width:%.3f%%;}\n",$cw-$sbw,$sbw));
    }
    $sbw = weaverii_getopt('sb_left_2_col_width_int');
    if ($sbw != '') {
	weaverii_f_write($sout,
	    sprintf("#container_wrap.left-2-col,#container_wrap.left-2-col-bottom{width:%.3f%%;} #sidebar_wrap_left.left-2-col,#sidebar_wrap_left.left-2-col-bottom{width:%.3f%%;}\n",$cw-$sbw,$sbw));
    }

    $sbwl = weaverii_getopt('sb_split_left_width_int');
    $sbwr = weaverii_getopt('sb_split_right_width_int');
    if ($sbwl != '' && $sbwr != '') {
	weaverii_f_write($sout,
	    sprintf("#container_wrap{width:%.3f%%;} #sidebar_wrap_left{width:%.3f%%;} #sidebar_wrap_right{width:%.3f%%;}\n",
	    $cw-$sbwl-$sbwr,$sbwl,$sbwr));
    }
    } // end no default specified

// Margins for sidebar widget areas

    $m = weaverii_getopt('wii_sidbar_widget_margins_L');
    if ($m != '')
	weaverii_f_write($sout,
	    sprintf("#sidebar_primary,#sidebar_left,#sidebar_right,.mobile_widget_area {margin-left:%spx !important;}\n",$m));
    $m = weaverii_getopt('wii_sidbar_widget_margins_R');
    if ($m != '')
	weaverii_f_write($sout,
	    sprintf("#sidebar_primary,#sidebar_left,#sidebar_right,.mobile_widget_area {margin-right:%spx !important;}\n",$m));


    $sbw = weaverii_getopt('sb_2_left_area_int');
    if ($sbw != '') {
	weaverii_f_write($sout,
	    sprintf("#sidebar_wrap_2_left_left, #sidebar_wrap_2_right_left {width:%.3f%%;margin-right:1%%;}\n#sidebar_wrap_2_left_right, #sidebar_wrap_2_right_right {width:%.3f%%;}\n",$sbw-1,$cw-$sbw));
    }

    $t = weaverii_getopt('wii_site_margins_T');
    $b = weaverii_getopt('wii_site_margins_B');
    $l = weaverii_getopt('wii_site_margins_L');
    $r = weaverii_getopt('wii_site_margins_R');

    if ($t != '' || $b != '' || $l != '' || $r != '') {
	if ($t == '') $t = 20;	// default if not set
	if ($b == '') $b = 20;
	if ($l == '') $l = 20;
	if ($r == '') $r = 20;
	weaverii_f_write($sout, sprintf("body {padding: %dpx %dpx %dpx %dpx; }\n",$t,$r,$b,$l));
    }


// === HEADER HORIZONTAL WIDGET AREA

    weaverii_put_bgcolor($sout,'_wii_hdr_widg_bgcolor','#sidebar_header');
    weaverii_css_style_val($sout, '#sidebar_header', '{height:%dpx;}',
			   '_wii_hdr_widg_h_int');
    weaverii_css_style_val($sout, '#sidebar_header', '{font-size:%d%%;}',
			   '_wii_hdr_widg_fontsize');


    for ($i = 1; $i < 5 ; $i++) {
	weaverii_put_bgcolor($sout,'_wii_hdr_widg_' . $i .'_bgcolor','#sidebar_header .header-widget-' . $i);
	if (($val = weaverii_getopt('_wii_hdr_widg_' . $i .'_w_int')) != '') {		// wii_after_header
	    if ($val == '0')
		weaverii_f_write($sout, sprintf(".sidebar-header .header-widget-%d {display:none;}\n", $i));
	    else {
		weaverii_f_write($sout, sprintf(".sidebar-header .header-widget-%d {width:%d%% !important;}\n", $i, $val));
	    }
	}
	if (($valm = weaverii_getopt('_wii_hdr_widg_' . $i .'_w_mobile_int')) != '') {		// wii_after_header
	    if ($valm == '0')
		weaverii_f_write($sout, sprintf(".sidebar-header-mobile .header-widget-%d {display:none;}\n", $i));
	    else
		weaverii_f_write($sout, sprintf(".sidebar-header-mobile .header-widget-%d {width:%d%%;}\n", $i, $valm));
	} else if ($val  != '') {	// if not a sidebar value, then use regular value
	    if ($val == '0')
		weaverii_f_write($sout, sprintf(".sidebar-header-mobile .header-widget-%d {display:none;}\n", $i));
	    else
		weaverii_f_write($sout, sprintf(".sidebar-header-mobile .header-widget-%d {width:%d%%;}\n", $i, $val));
	}
    }

// =========================== HEADER OPTIONS ===============================
    weaverii_css_style_val($sout, '#branding', '{padding-top:%dpx;}',
			   'wii_branding_padding_T');

    weaverii_css_style_val($sout, '#branding', '{padding-bottom:%dpx;}',
			   'wii_branding_padding_B');

    weaverii_css_style_val($sout, '#main', '{padding: %dpx 0 0 0;}',
			   'wii_after_header_int');

    weaverii_css_style_val($sout, '#site-title', '{font-size:%.3f%%;}',
			   'wii_title_font_size');

    weaverii_css_style_val($sout, '#site-description', '{font-size:%.3f%%;}',
			   'wii_desc_font_size');

    weaverii_css_style_val($sout, '#site-title', '{max-width:%.3f%%;}',
			   'wii_title_max_w');

    weaverii_css_style_val($sout, '#site-description', '',
			   'wii_desc_max_w');

/* Site Title/Description

    Site Title' => 'wii_title_color'
    Site Title Font Size => 'wii_title_font_size'
    Title Position => 'wii_title_position_xy'
    Move Title over Header Image => 'wii_title_over_header'

    Site Description => 'wii_desc_color'
    Site Description Font Size => 'wii_desc_font_size'
    Description Position => 'wii_desc_position_xy'
    Move Description over Header Image => 'wii_desc_over_header'

    Header Extra HTML => 'wii_header_html'
    Extra HTML Position => 'wii_header_html_position_xy',
    Move Extra HTML over Header Image => 'wii_header_html_over_header'
    <small>Hide on Mobile', 'id' =>'wii_header_html_hide_mobile'
*/
    $newway = false;
    if (weaverii_getopt('wii_title_over_header')) {
	$newway = true;
	$tx = 2; $ty = 5; // default values for offsets
	$val = weaverii_getopt('wii_title_position_xy_X'); if ($val != '') $tx = $val;
	$val = weaverii_getopt('wii_title_position_xy_Y'); if ($val != '') $ty = $val;
	weaverii_f_write($sout,
	    sprintf("#site-title {overflow:hidden; padding:0; margin:0; position:absolute; left:%.3f%%; top: %.3f%%; z-index:20;}\n",$tx,$ty));
	if (weaverii_getopt('wii_title_over_header_mobile'))
	    weaverii_f_write($sout, ".weaver-mobile #site-title {overflow:hidden;padding:0;position:absolute;left:6px;top:2px;}\n");
    } else {
	$tx = weaverii_getopt('wii_title_position_xy_X');
	$ty = weaverii_getopt('wii_title_position_xy_Y'); // new title margins
	if ($tx != '' || $ty != '') {
	    $newway = true;
	    weaverii_f_write($sout, sprintf("#site-title{ margin-left:%.3f%%; margin-top:%.3f%%;}\n",$tx,$ty));
	}
    }

    if (weaverii_getopt('wii_desc_over_header')) {
	$newway = true;
	$tx = 4; $ty = 30; // default values for offsets
	$val = weaverii_getopt('wii_desc_position_xy_X'); if ($val != '') $tx = $val;
	$val = weaverii_getopt('wii_desc_position_xy_Y'); if ($val != '') $ty = $val;
	weaverii_f_write($sout,
	    sprintf("#site-description {overflow:hidden; padding:0; margin:0; position:absolute; left:%.3f%%; top: %.3f%%; z-index:20;}\n",
		$tx,$ty));
    } else {
	$tx = weaverii_getopt('wii_desc_position_xy_X');
	$ty = weaverii_getopt('wii_desc_position_xy_Y'); // new title margins
	if ($tx != '' || $ty !='') {
	    $newway = true;
	    weaverii_f_write($sout, sprintf("#site-description{ margin-left:%.3f%%; margin-top:%.3f%%;}\n",$tx,$ty));
	}
    }

    if (weaverii_getopt('wii_header_html_over_header')) {
	$tx = 4; $ty = 40; // default values for offsets
	$val = weaverii_getopt('wii_header_html_position_xy_X'); if ($val != '') $tx = $val;
	$val = weaverii_getopt('wii_header_html_position_xy_Y'); if ($val != '') $ty = $val;
	weaverii_f_write($sout,
	    sprintf("#header-extra-html {overflow:hidden; padding:0; margin:0; position:absolute; left:%.3f%%; top: %.3f%%; z-index:20;}\n",
		$tx,$ty));
    } else {
	$tx = weaverii_getopt('wii_header_html_position_xy_X');
	$ty = weaverii_getopt('wii_header_html_position_xy_Y'); // new title margins
	if ($tx != '' || $ty != '') {
	    weaverii_f_write($sout, sprintf("#header-extra-html { margin-left:%.3f%%; margin-top:%.3f%%;}\n",$tx,$ty));
	}
    }

/*  wii_title_on_header */

    if (!$newway && weaverii_getopt_checked('wii_title_on_header')) {
	$tx = 40; $ty = 44; // default values for offsets
	$dx = 48; $dy = 90;
	$val = weaverii_getopt('wii_title_on_header_xy_X'); if ($val != '') $tx = (int) $val;
	$val = weaverii_getopt('wii_title_on_header_xy_Y'); if ($val != '') $ty = (int) $val;
	$val = weaverii_getopt('wii_title_on_header_xy_desc_X'); if ($val != '') $dx = (int) $val;
	$val = weaverii_getopt('wii_title_on_header_xy_desc_Y'); if ($val != '') $dy = (int) $val;

	weaverii_f_write($sout, sprintf("#site-title {overflow:hidden; padding:0; margin:0; position:absolute; left:%dpx; top: %dpx; z-index:20;}\n",$tx,$ty));
	weaverii_f_write($sout, sprintf(".weaver-mobile #site-title {position: relative; z-index:20;}\n"));
	weaverii_f_write($sout, sprintf("#site-description {overflow:hidden; margin:0; padding:0; clear: both; position:absolute; left: %dpx; top: %dpx; z-index:20;}\n",$dx,$dy));
	$tpc = 99 - (($tx/768)*100);	// force title, description to fit withing tablet width - works for either 768 or 800
	$dpc = 99 - (($dx/768)*100);
	weaverii_f_write($sout, sprintf(".weaver-tablet #site-title.title-on-header{white-space:nowrap;margin-left:0;margin-right:0; overflow:hidden;width:%d%%;}\n",$tpc));
	weaverii_f_write($sout, sprintf(".weaver-tablet #site-description.title-on-header{margin-left:0;margin-right:0;white-space:nowrap;overflow:hidden;width:%d%%;}\n",$dpc));
    }

    if (($val = weaverii_getopt('wii_header_width_int')) != '') { // doesn't work right if use max-width
	if ($val > $themew) {
	    weaverii_f_write($sout, sprintf("#branding {width:%dpx; margin-left:-%dpx;}\n",$val, ($val-$themew)/2));
	} else if ($val != $themew) {
	    weaverii_f_write($sout, sprintf("#branding {width:%dpx; margin-left:%dpx;}\n",$val, ($themew-$val)/2));
	}
    }

// =========================== FOOTER OPTIONS ===============================

/*  wii_footer_border_color  */
    $fh = weaverii_getopt('wii_footer_border_int');
    if ($fh == '') $fh = '4';
    $fc = weaverii_getopt('wii_footer_border_color');
    if ($fc == '') $fc = '#888';

    if ($fh != '4' || $fc != '#888') {	// write if not defaults
	weaverii_f_write($sout, sprintf("#colophon { border-top: %dpx solid %s;  }\n",$fh, $fc));
    }

    weaverii_css_css($sout,'#colophon','wii_footer_border_color_css');


    if (($val = weaverii_getopt('wii_footer_width_int')) != '') {
	if ($val > $themew) {
	    weaverii_f_write($sout, sprintf("#colophon {width:%dpx; margin-left:-%dpx;}\n",$val, ($val-$themew)/2));
	}
    }

    if (weaverii_getopt('_wii_hide_poweredby'))
	weaverii_f_write($sout, "#site-info {width:80%;}\n");

// =========================== MENU OPTIONS ===============================
/*
text_color = 0.213 * this.rgb[0] +
	    0.715 * this.rgb[1] +
	    0.072 * this.rgb[2]
	    < 0.5 ? '#FFF' : '#000';
*/

    weaverii_put_rule_if_checked($sout,'wii_bold_menu','.menu_bar a, .mobile_menu_bar a {font-weight:bold;}');	// weaverii_put_rule_if_checked
    weaverii_put_rule_if_checked($sout,'wii_bold_submenu','.menu_bar ul ul a {font-weight:bold;}');	// wii_bold_submenu
    weaverii_put_rule_if_checked($sout,'wii_menubar_curpage_em',
	'.menu_bar .current_page_item > a, .menu_bar .current-menu-item > a, .menu_bar .current_page_ancestor > a {font-style:italic;}');	// wii_menubar_curpage_em
    weaverii_put_rule_if_checked($sout,'wii_menubar_curpage_bold',
	'.menu_bar .current_page_item > a, .menu_bar .current-menu-item > a, .menu_bar .current_page_ancestor > a {font-weight:bold;}');

    if (($val = weaverii_getopt('wii_menu_height_int')) != '') {		//+ wii_menu_height_int
	weaverii_f_write($sout,sprintf("#nav-bottom-menu, #nav-top-menu {min-height:%dpx;}\n",$val));
	weaverii_f_write($sout,sprintf(".menu_bar a {line-height:%dpx !important;}\n",$val));
	weaverii_f_write($sout,sprintf(".menu_bar ul ul a {line-height:%dpx !important;}\n",$val-20));
	weaverii_f_write($sout,sprintf(".menu_bar ul ul {top:%dpx;}\n",$val));
    }

    weaverii_css_style_val($sout, '#access .menu', '{padding-left:%spx;}',
			   'wii_menu_leftpad_int');

    weaverii_css_style_val($sout, '#access2 .menu', '.menu{padding-left:%spx;}',
			   'wii_menu_leftpad2_int');

    weaverii_css_style_val($sout, '.menu_bar a', '{padding: 0 %dpx;}',
			   'wii_menu_spacing_int');

     $separator_width = 2;
    $val = weaverii_getopt('wii_separator_width_int');	//+
    if ((int) $val > 0) $separator_width = $val;

    $separator_color = weaverii_getopt('wii_menubar_text_color');
    if ($separator_color == '') $separator_color = '#FFF';

    if (weaverii_getopt_checked('wii_menubar_sep')) {	//+
	weaverii_f_write($sout,sprintf(".menu_bar ul li {border-left:%dpx solid %s;}\n",
	    $separator_width,$separator_color));
	weaverii_f_write($sout,sprintf(".menu_bar ul li:last-child, .menu_bar ul ul li {border-right:%dpx solid %s;}\n",
	    $separator_width,$separator_color));

	weaverii_f_write($sout,".menu_bar ul ul ul li {margin-left:0px;}\n");
    }

    $separator_color = weaverii_getopt('wii_submenubar_text_color');
    if ($separator_color == '') $separator_color = '#FFF';
    if (weaverii_getopt('wii_submenu_bars')) {	//+
	weaverii_f_write($sout,sprintf(".menu_bar ul ul li {border-left:%dpx solid %s;border-right:%dpx solid %s;border-bottom:%dpx solid %s;}\n",
	       $separator_width,$separator_color,$separator_width,$separator_color,$separator_width,$separator_color));
	weaverii_f_write($sout,sprintf(".menu_bar ul ul li:first-child{border-top:%dpx solid %s;}\n",
	       $separator_width,$separator_color));
    }
    $val = weaverii_getopt('wii_menu_liwidth');	//+
    if ((int) $val > 0) {
	weaverii_f_write($sout,sprintf(".menu_bar ul li{width:%dpx;}\n",$val));
    }
    if (weaverii_getopt_checked('wii_submenu_dotted')) {	//+
	$separator_color = weaverii_getopt('wii_submenubar_text_color');
	if ($separator_color == '') $separator_color = '#000';
	weaverii_f_write($sout, sprintf(".menu_bar ul ul a {border-bottom: 1px dotted %s;}\n",$separator_color));
    }

    if (($gtop = weaverii_getopt('grad_top')) != '' && !weaverii_getopt('grad_disable')) {	// custom gradient?

	$grad = '';
	if (weaverii_getopt('gradient_header')) $grad .= '#branding,';
	if (weaverii_getopt('wii_gradient_menu'))
	    $grad .= '.menu_bar, .weaveriip_vertical_menu .menu_bar li a,.menu_bar ul ul a, .menu_bar li:hover > a, .menu_bar ul ul :hover > a,.mobile_menu_bar,.menu-vertical,.menu-vertical li a, .menu-vertical ul ul a, .menu-vertical li:hover >a, .menu-vertical ul ul:hover >a,';
	if (weaverii_getopt('wii_widget_widget_gradient')) $grad .= '.widget,';
	if (weaverii_getopt('wii_widget_primary_gradient')) $grad .= '#sidebar_primary,';
	if (weaverii_getopt('wii_widget_right_gradient')) $grad .= '#sidebar_right,';
	if (weaverii_getopt('wii_widget_left_gradient')) $grad .= '#sidebar_left,';
	if (weaverii_getopt('wii_widget_top_gradient')) $grad .= '.sidebar_top,';
	if (weaverii_getopt('wii_widget_bottom_gradient')) $grad .= '.sidebar_bottom,';
	if (weaverii_getopt('wii_widget_footer_gradient')) $grad .= '#sidebar_wrap_footer .widget-area,';
	if (weaverii_getopt('gradient_content')) $grad .= '#content,';
	if (weaverii_getopt('gradient_footer')) $grad .= '#colophon,';
	$grad .= '.wvr-gradient';
	$gbot = weaverii_getopt('grad_bottom');
	if ($gbot == '') $gbot = $gtop + 0x202020;	// just try some value if none set
	$ietop = weaverii_rgba2argb($gtop);
	$iebot = weaverii_rgba2argb($gbot);
	$gcss = $grad . '{background-image: -webkit-gradient(linear, left top, left bottom, from(%t%), to(%b%));
background-image: -webkit-linear-gradient(top, %t%, %b%);
background-image: -moz-linear-gradient(top, %t%, %b%);
background-image: -o-linear-gradient(top, %t%, %b%);
background-image: -ms-linear-gradient(top, %t%, %b%);
background-image: linear-gradient(to bottom, %t%, %b%);
filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=\'%s\', endColorstr=\'%s\');}' . "\n";
	$gcss = str_replace('%t%',$gtop,$gcss);
	$gcss = str_replace('%b%',$gbot,$gcss);	// easier than counting %s's

	weaverii_f_write($sout, sprintf($gcss,$ietop,$iebot));

    } else if (weaverii_getopt('wii_gradient_menu')) {	// wii_gradient_menu
	$urlfade = weaverii_relative_url('images/theme/fade.png');
	$urlfadeup = weaverii_relative_url('images/theme/fadeup.png');
	    weaverii_f_write($sout, sprintf(".menu_bar, .weaveriip_vertical_menu .menu_bar li { background-image: url(%s);}\n", $urlfade));

	weaverii_f_write($sout, sprintf(".menu_bar ul ul a, .menu_bar li:hover > a, .menu_bar ul ul :hover > a { background-image: url(%s);}\n",
	       $urlfadeup));
    }

    if (weaverii_getopt_checked('wii_menu_shadow')) {
	if (($headerw = weaverii_getopt('wii_footer_width_int')) == '')	//+
	    $headerw = $themew;
	weaverii_f_write($sout, sprintf('.menu_bar {-webkit-box-shadow: rgba(0, 0, 0, 0.4) 0px 0px 2px;
-moz-box-shadow: rgba(0, 0, 0, 0.4) 0px 0px 2px; box-shadow: rgba(0, 0, 0, 0.4) 0px 0px 2px;margin-left:1px;max-width:%dpx;}',$headerw-2));
    }


/*	wii_use_superfish	*/
    //if (!weaverii_getopt('wii_use_superfish')) {
    //		need to fix up access a if NOT using SuperFish - at least with Weaver, maybe not here
    //	weaverii_f_write($sout, sprintf(".menu_bar a { padding-left:10px; padding-right:10px;}\n"));
    // }
    if ( weaverii_use_sf() ) {
	weaverii_f_write($sout,".menu_bar ul ul a {padding:10px 20px;}\n"); // make room for arrow
    	$arrows = weaverii_getopt('wii_superfish_arrows');
	if ($arrows && $arrows != '000000') {	/* assumes 000000 is default arrow color */
	    if (is_rtl() || WEAVERII_FORCE_RTL)
		$url = weaverii_relative_url('js/superfish/images/rtl-arrows-' . $arrows . '.png');
	    else
		$url = weaverii_relative_url('js/superfish/images/arrows-' . $arrows . '.png');
	    weaverii_f_write($sout,
		sprintf(".sf-sub-indicator {background: url(%s) no-repeat -10px -100px;}\n",$url));
	}
    }

    weaverii_put_color($sout,'wii_menubar_text_color','.menu_bar, .menu_bar a,.menu_bar a:visited,.mobile_menu_bar a');
    weaverii_put_bgcolor($sout,'wii_menubar_hover_bgcolor','.menu_bar li:hover > a, .menu_bar a:focus');	// wii_menubar_hoverbg_color
    weaverii_put_color($sout,'wii_menubar_hover_color','.menu_bar li:hover > a, .menu_bar a:focus');	// wii_menubar_hover_color
    weaverii_put_bgcolor($sout,'wii_submenubar_bgcolor','.menu_bar ul ul a');	// wii_submenubar_bgcolor
    weaverii_put_color($sout,'wii_submenubar_text_color','.menu_bar ul ul a,.menu_bar ul ul a:visited');	// wii_submenubar_text_color
    weaverii_put_bgcolor($sout,'wii_submenubar_hover_bgcolor','.menu_bar ul ul :hover > a');	// wii_submenubar_hover_bgcolor
    weaverii_put_color($sout,'wii_submenubar_hover_color','.menu_bar ul ul :hover > a');	// wii_submenubar_hover_color
    weaverii_put_color($sout,'wii_menubar_curpage_color',
	'.menu_bar .current_page_item > a, .menu_bar .current-menu-item > a, .menu_bar .current_page_ancestor > a',true);	// wii_menubar_curpage_color

    weaverii_put_bgcolor($sout,'wii_menubar_bgcolor','.menu_bar, .mobile_menu_bar');	// wii_menubar_bgcolor

/* info bar */
//  wii_info_color wii_info_padding

    weaverii_put_bgcolor($sout,'wii_infob_bgcolor','#infobar');
    weaverii_put_color($sout,'wii_infob_color','#infobar');

    weaverii_css_style_val($sout, '#infobar', '{padding-left:%dpx;}',
			   'wii_infob_padding_L');

    weaverii_css_style_val($sout, '#infobar', '{padding-right:%dpx;}',
			   'wii_infob_padding_R');

    weaverii_css_style_val($sout, '#infobar', '{padding-top:%dpx;}',
			   'wii_infob_padding_T');

    weaverii_css_style_val($sout, '#infobar', '{padding-bottom:%dpx;}',
			   'wii_infob_padding_B');

 /* vertical menu */
    $mb_bg = weaverii_getopt('wii_menubar_bgcolor');		// Build the simple vertical menu based on existing
    $mb_sub = weaverii_getopt('wii_menubar_bgcolor');		// theme menu colors.
    $mb_hover = weaverii_getopt('wii_menubar_hover_bgcolor');
    $text_color = weaverii_getopt('wii_menubar_text_color');
    $text_hover = weaverii_getopt('wii_menubar_hover_color');
    $cur_page = weaverii_getopt('wii_menubar_curpage_color');
    if ($cur_page == '') $cur_page = 'inherit';
    $cur_page_css = weaverii_getopt('wii_menubar_curpage_color_css');
    if (weaverii_getopt('wii_bold_menu')) $bold = 'font-weight:bold;';
    else $bold = '';

    weaverii_f_write($sout,sprintf(".mobile-menu-link {border-color:%s;}\n",$text_color));

    $menu = sprintf(".menu-vertical {clear:both;background:transparent;margin:0;width:100%% !important;overflow:hidden !important;border-bottom:3px solid %s;border-top:1px solid %s;%s;}
.menu-vertical ul {margin: 0 !important; padding: 0 !important; list-style-type: none !important;  list-style-image:none !important;font-family: inherit;}
.menu-vertical li a, .menu-vertical a:visited {color: %s !important;  background-color: %s !important;
 display: block !important; padding: 5px 10px !important; text-decoration: none !important;
 border-top:2px solid %s;}
.menu-vertical a:hover,.menu-vertical a:focus {color: %s !important; background-color: %s !important;text-decoration: none !important;}
.menu-vertical ul ul li { margin: 0 !important; }
.menu-vertical ul ul a {color: %s !important; background-color: %s !important;
 display: block !important; padding: 4px 5px 4px 25px !important; text-decoration: none !important;border:0;
 border-top:1px solid %s;}
.menu-vertical ul ul a:hover {color: %s !important; background-color: %s !important; text-decoration: none !important;}
.menu-vertical ul ul ul a {padding: 4px 5px 4px 35px !important;}
.menu-vertical ul ul ul ul a {padding: 4px 5px 4px 45px !important;}
.menu-vertical ul ul ul ul ul a {padding: 4px 5px 4px 55px !important;}
.menu-vertical ul li.current_page_item > a, .menu-vertical ul li.current-menu-item > a  {color:%s !important;}\n",
$text_color, $text_color, $bold, $text_color, $mb_bg, $text_color, $text_hover, $mb_hover,
$text_color, $mb_sub, $text_color, $text_hover, $mb_hover, $cur_page );
    if ($cur_page_css)
        $menu .= sprintf(".menu-vertical ul li.current_page_item > a, .menu-vertical ul li.current-menu-item > a %s\n", $cur_page_css);
    if (weaverii_getopt('wii_menubar_curpage_em'))
        $menu .= ".menu-vertical ul li.current_page_item > a, .menu-vertical ul li.current-menu-item > a {font-style:italic;}\n";
    if (weaverii_getopt('wii_menubar_curpage_bold'))
        $menu .= ".menu-vertical ul li.current_page_item > a, .menu-vertical ul li.current-menu-item > a {font-weight:bold;}\n";

    weaverii_f_write($sout,$menu);

// =========================== CONTENT AREAS ===============================


/*   wii_entrytitle_size_int */
    weaverii_css_style_val($sout, '#content .entry-title', '{font-size:%d%%;}',
			   'wii_entrytitle_size_int');

    $val = weaverii_getopt('wii_contentlist_bullet');
    if ($val != '' && $val != 'disc') {
	if ($val == 'custom') {
	    $url = weaverii_getopt('wii_contentlist_bullet_custom_url');
	    if ($url != '')
		weaverii_f_write($sout, sprintf("#content ul {list-style-image:url(%s);}\n",apply_filters('weaverii_css',$url)));
	} else {
	    weaverii_f_write($sout, sprintf("#content ul {list-style-type:%s;}\n",$val));
	}
    }

    $val = (int)weaverii_getopt('wii_header_underline_int');       /* bar under headers */
    if ($val != '' && $val != 0) {
        $titleColor = weaverii_getopt('wii_page_title_color');
	if ($titleColor == '') $titleColor = '#222';
        weaverii_f_write($sout, sprintf(".entry-title {border-bottom: $val"."px solid $titleColor;}\n"));
    }

    weaverii_css_style_val($sout, '.entry-content,.entry-summary', '{padding-top:%.3fem;}',
			   'wii_content_top_dec');

    weaverii_css_style_val($sout, '#content p,#content ul,#content ol', '{margin-bottom:%.3fem;}',
			   'wii_content_p_list_dec');

    /*  wii_content_color  */
    weaverii_put_color($sout,'wii_content_color','#content, .entry-content h1, .entry-content h2');

    /*  wii_content_headings_color  */
    weaverii_put_color($sout,'wii_content_headings_color',
	'#content h1, #content h2, #content h3, #content h4, #content h5, #content h6, #content dt, #content th,
h1, h2, h3, h4, h5, h6,.entry-author-info h2');


/*  wii_page_title_color - MUST come after wii_content_headings_color! */

    weaverii_put_color($sout, 'wii_page_title_color','#content h1.entry-title');

/* Comments */

    weaverii_put_color($sout, 'wii_comment_headings_color', '#comments-title h3, #comments-title h4, #respond h3' );
    weaverii_put_bgcolor($sout, 'wii_comment_content_bgcolor', '.commentlist li.comment, #respond' );
    weaverii_put_bgcolor($sout,'wii_comment_submit_bgcolor','#respond input#submit');
    weaverii_put_rule_if_checked($sout,'wii_form_allowed_tags','#commentform .form-allowed-tags {display:block;}');
    weaverii_put_rule_if_checked($sout,'wii_hide_comment_bubble', '#comments-title {background-image:none;padding-left:0px;font-size:140%;}');
    weaverii_put_rule_if_checked($sout,'wii_hide_comment_hr', 'hr.comments-hr {display:none;}');
    weaverii_put_rule_if_checked($sout,'wii_hide_comment_borders', '.commentlist li.comment, #respond,.commentlist li.comment .comment-author img.avatar,.commentlist .comment.bypostauthor {border:none;}');

/*  wii_weaverii_tables  */
    $table = weaverii_getopt('wii_weaverii_tables');

    if ($table == 'wide') {	// make backward compatible with 1.4 and before when Twenty Ten was default
	weaverii_f_write($sout, sprintf("#content table {border: 1px solid #e7e7e7;margin: 0 -1px 24px 0;text-align: left;width: 100%%;}
#content tr th, #content thead th {color: #888;font-size: 12px;font-weight: bold;line-height: 18px;padding: 9px 24px;}
#content tr td {border-style:none; border-top: 1px solid #e7e7e7; padding: 6px 24px;}
#content tr.odd td {background: #f2f7fc;}\n"));
    } else
    if ($table == 'bold') {
	weaverii_f_write($sout, sprintf("#content table {border: 2px solid #888;}
#content tr th, #content thead th {font-weight: bold;}
#content tr td {border: 1px solid #888;}\n"));
    } else
    if ($table == 'noborders') {
	weaverii_f_write($sout, sprintf("#content table {border-style:none;}
#content tr th, #content thead th {font-weight: bold;border-bottom: 1px solid #888;background-color:transparent;}
#content tr td {border-style:none;}\n"));
    } else
    if ($table == 'fullwidth') {
	weaverii_f_write($sout, sprintf("#content table {width:100%%;}
#content tr th, #content thead th {font-weight:bold;}\n"));
    } else
    if ($table == 'plain') {
	weaverii_f_write($sout, sprintf(
"#content table {border: 1px solid #888;text-align:left;margin: 0 0 0 0;width:auto;}
#content tr th, #content thead th {color: inherit;background:none;font-weight:normal;line-height:normal;padding:4px;}
#content tr td {border: 1px solid #888; padding:4px;}\n"));
    }

    weaverii_css_style_val($sout, '#content .size-full, #content .size-large, #content .size-medium, #content .size-thumbnail,#content .size-thumbnail, #content .gallery img,#content .gallery-thumb img,.entry-attachment img,#content .wp-caption img, #content img.wp-post-image,#content img[class*=\"wp-image-\"]', '{padding:%dpx;}',
			   'wii_media_lib_border_int');

    weaverii_css_style_val($sout, '#content .page .featured-image img.wp-post-image', '{height: auto; max-width:%spx !important;}',
			   'wii_featured_page_width');

    weaverii_css_style_val($sout, '.single-post #content .post .featured-image img.wp-post-image',
			   '{height: auto; max-width:%spx !important;}',
			   'wii_featured_single_width');


    if (($val = weaverii_getopt('wii_featured_blog_width')) != '') {
	weaverii_f_write($sout,sprintf(".blog #content .featured-image img.wp-post-image, .archive #content .featured-image img.wp-post-image, #content .wvr-show-posts .featured-image img.wp-post-image {height: auto; max-width:%spx;}\n",$val));
	weaverii_f_write($sout,sprintf(".widget .wvr-show-posts .featured-image img.wp-post-image {height: auto; width:%spx;}\n",$val));
	// use width for widget areas - the widget area max-width will override if needed
    }


    if (weaverii_getopt_checked('wii_hide_img_borders')) {
	weaverii_f_write($sout,"#content .size-full, #content .size-large, #content .size-medium, #content .size-thumbnail,#content .size-thumbnail, #content .gallery img,#content .gallery-thumb img,.entry-attachment img, #content img[class*=\"wp-image-\"] {background-color:transparent !important;}\n");
	weaverii_f_write($sout, "#content img, #author-avatar img {-webkit-box-shadow: none !important; -moz-box-shadow: none !important;box-shadow: none !important;}\n");
    }
    if (weaverii_getopt_checked('wii_hide_img_shadows') && !weaverii_getopt_checked('wii_hide_img_borders')) {
	weaverii_f_write($sout, "#content img,#author-avatar img {-webkit-box-shadow: none !important; -moz-box-shadow: none !important;box-shadow: none !important;}\n");
    }

    weaverii_css_style_val($sout, '#content', '{padding-left:%dpx;}',
			   'wii_content_padding_L');

    weaverii_css_style_val($sout, '#content', '{padding-right:%dpx;}',
			   'wii_content_padding_R');

    weaverii_css_style_val($sout, '#content', '{padding-top:%dpx;}',
			   'wii_content_padding_T');

    weaverii_css_style_val($sout, '#content', '{padding-bottom:%dpx;}',
			   'wii_content_padding_B');

   /*  wii_caption_color  */
    weaverii_put_color($sout,'wii_caption_color','#content .wp-caption p.wp-caption-text, #content .gallery .gallery-caption,.entry-attachment .entry-caption');

    /* wii_media_lib_border */
    $tag = '#content img.size-full, #content img.size-large, #content img.size-medium, #content img.size-thumbnail, #content .attachment-thumbnail, #content .gallery img,#content .gallery-thumb img,.entry-attachment img, #content .wp-caption img, #content img.wp-post-image,#content img[class*="wp-image-"]';

    if (!weaverii_getopt_checked('wii_hide_img_borders')) {
	weaverii_put_bgcolor($sout,'wii_media_lib_border_color', $tag);
    } else if (($style = weaverii_getopt('wii_media_lib_border_color_css')) ) { // special case
	weaverii_f_write($sout, sprintf("%s %s\n",$tag,$style));
    }

// =========================== POST SPECIFIC AREAS ===============================

    weaverii_put_rule_if_checked($sout, 'wii_show_comments_closed','.nocomments {display:block;}');

    weaverii_put_rule_if_checked($sout, 'wii_nav_show_first','#nav-above{display:block;}'); // put this one first, so hide can override
    weaverii_put_rule_if_checked($sout, 'wii_nav_hide_above','#nav-above,.paged #nav-above{display:none;margin:0;}');
    weaverii_put_rule_if_checked($sout, 'wii_nav_hide_below','#nav-below{display:none;margin:0;}');

    if (weaverii_getopt('wii_single_nav_style') == 'hide' || weaverii_getopt_checked('wii_single_nav_hide_above')) {
	weaverii_f_write($sout,".single #nav-above{display:none;margin:0;}\n");
    }
    if (weaverii_getopt('wii_single_nav_style') == 'hide' || weaverii_getopt_checked('wii_single_nav_hide_below')) {
	weaverii_f_write($sout,".single #nav-below{display:none;margin:0;}\n");
    }
    $nav = weaverii_getopt('wii_nav_style');	// paged can take more than 50%
    if ($nav == 'paged_left')
	weaverii_f_write($sout,".nav-previous {width:95%;}\n");
    if ($nav == 'paged_right')
	weaverii_f_write($sout,".nav-next {width:95%;}\n");

    weaverii_put_rule_if_checked($sout, 'wii_mobile_post_info_hide_top','.weaver-mobile .entry-meta{display:none;}');
    weaverii_put_rule_if_checked($sout, 'wii_mobile_post_info_hide_bottom','.weaver-mobile .entry-utility{display:none;}');

    /*  wii_stickypost_bgcolor  */
    weaverii_put_bgcolor($sout,'wii_stickypost_bgcolor', '.home .sticky, #entry-author-info, #container.page-with-posts .sticky, #container.index-posts .sticky');

    weaverii_css_style_val($sout, '#content .post', '{padding-left:%dpx;}',
			   'wii_post_padding_L');

    weaverii_css_style_val($sout, '#content .post', '{padding-right:%dpx;}',
			   'wii_post_padding_R');

    weaverii_css_style_val($sout, '#content .post', '{padding-top:%dpx;}',
			   'wii_post_padding_T');

    weaverii_css_style_val($sout, '#content .post', '{padding-bottom:%dpx;}',
			   'wii_post_padding_B');

    weaverii_put_color($sout,'wii_post_format_color','#content .entry-format');	// wii_post_format_color

    weaverii_put_color($sout,'wii_info_color','.entry-meta, .entry-content label, .entry-utility');		/*  wii_info_color  */

    weaverii_put_rule_if_checked($sout, 'wii_post_hide_single_author','.single-author .entry-meta .by-author {display:none;}');

// ============================== WIDGET AREAS ===================================


    $val = weaverii_getopt('wii_widgetlist_bullet');
    if ($val != '' && $val != 'disc') {
	if ($val == 'custom') {
	    $url = weaverii_getopt('wii_widgetlist_bullet_custom_url');
	    if ($url != '')
		weaverii_f_write($sout, sprintf(".widget ul {list-style-image:url(%s);}\n",apply_filters('weaverii_css',$url)));
	} else {
	    weaverii_f_write($sout, sprintf(".widget ul {list-style-type:%s;}\n",$val));
	}
    }

// ================================== FONTS =====================================

    weaverii_css_style_val($sout, 'body', '{font-size:%dpx;}',
			   'wii_site_fontsize_int');

    weaverii_css_style_val($sout, 'body.weaver-mobile', '{font-size:%dpx;}',
			   'wii_site_fontsize_mobile_int');

    weaverii_css_style_val($sout, 'body', '{line-height:%.3f;}',
			   'wii_site_line_height_dec');

    weaverii_css_style_val($sout, 'body', '{font-family:%s;}',
			   'wii_content_font');

    weaverii_css_style_val($sout, 'h3#comments-title,h3#reply-title,.menu_bar,.mobile_menu_bar,
#author-info,#infobar,#nav-above, #nav-below,#cancel-comment-reply-link,.form-allowed-tags,
#site-info,#site-title,#wp-calendar,#comments-title,.comment-meta,.comment-body tr th,.comment-body thead th,
.entry-content label,.entry-content tr th,.entry-content thead th,.entry-format,.entry-meta,.entry-title,
.entry-utility,#respond label,.navigation,.page-title,.pingback p,.reply,.widget-title,
.wp-caption-text,input[type=submit]',
			    '{font-family:%s;}',
			   'wii_title_font');

// ================================ COLORS ===================================
// Colors need to go last because they might have CSS +
   /* background areas */

    weaverii_put_bgcolor($sout,'wii_body_bgcolor','body');		// body
    weaverii_put_color($sout,'wii_body_color','body');			// body
    weaverii_put_bgcolor($sout,'wii_page_bgcolor','#wrapper');		// #wrapper
    weaverii_put_bgcolor($sout,'wii_main_bgcolor','#main');		// #main
    weaverii_put_bgcolor($sout,'wii_container_bgcolor','#container');	// #container
    weaverii_put_bgcolor($sout,'wii_content_bgcolor','#content');	// #content
    weaverii_put_bgcolor($sout,'wii_post_bgcolor','.post');		// .post
    weaverii_put_bgcolor($sout,'wii_header_bgcolor','#branding');	// #header
    weaverii_put_bgcolor($sout,'wii_footer_bgcolor','#colophon');	// #footer
    weaverii_put_bgcolor($sout,'wii_footer_widget_bgcolor','#first,#second, #third, #fourth');	// #first,#second, #third, #fourth
    weaverii_put_bgcolor($sout,'wii_hr_color','hr');			// hr
    weaverii_put_bgcolor($sout,'wii_infotop_bgcolor','.entry-meta');	// .entry-meta
    weaverii_put_bgcolor($sout,'wii_infobottom_bgcolor','.entry-utility');	// .entry-utility
    /* input, text area */
    weaverii_put_bgcolor($sout,'wii_input_bgcolor','input, textarea, ins, pre');
    weaverii_put_color($sout,'wii_input_color','input, textarea');

    // Sidebar wrappers

    $sb_bg = array(
    'sb_right_1_col_bgcolor' => '#sidebar_wrap_right.right-1-col',	//+ ALL
    'sb_right_2_col_bgcolor' => '#sidebar_wrap_right.right-2-col,#sidebar_wrap_right.right-2-col-bottom',
    'sb_left_1_col_bgcolor' => '#sidebar_wrap_left.left-1-col',
    'sb_left_2_col_bgcolor' => '#sidebar_wrap_left.left-2-col,#sidebar_wrap_left.left-2-col-bottom',
    'sb_split_left_bgcolor' => '#sidebar_wrap_left',
    'sb_split_right_bgcolor' => '#sidebar_wrap_right' );

    foreach ($sb_bg as $id => $tag) {
	weaverii_put_bgcolor($sout,$id,$tag);	// #header
    }

   weaverii_put_bgcolor($sout,'sb_container_bgcolor','#container_wrap'); //+ container wrap
   // wii_widget_color wii_widget_title_color
/*  wii_widget_header_underline_int  */

    weaverii_put_color($sout,'wii_widget_color', '.widget');

    $titleColor = weaverii_getopt('wii_widget_title_color');

    if ($titleColor == '') $titleColor = weaverii_getopt('wii_page_title_color');
    if ($titleColor == '') $titleColor = '#222'; /* if they want a border, this is the fallback color */

    if (($val = weaverii_getopt('wii_widget_header_underline_int')) != '') {
        weaverii_f_write($sout, sprintf(".widget-title {border-bottom: $val"."px solid $titleColor; margin-bottom:5px;padding-bottom:3px;}\n"));
     }

/*  wii_widget_title_color  */
    weaverii_css_color($sout,'.widget-title, .widget_search label, #wp-calendar caption',
		       weaverii_getopt('wii_widget_title_color'));
    weaverii_css_css($sout,'.widget-title',
		     'wii_widget_title_color_css');

// site title/description
    weaverii_css_style_val($sout, '#site-title a', '{color:%s;}',
			   'wii_title_color');

    weaverii_css_css($sout,'#site-title, #site-title a',
		    'wii_title_color_css');

    weaverii_put_color($sout,'wii_desc_color','#site-description');		// wii_desc_color

    if (weaverii_getopt('wii_hide_site_title')) {
	weaverii_f_write($sout,
"@media only screen and (min-width: 581px) { #site-title{display:none;}}
#ie7 #site-title, #ie8 #site-title {display:none;}
.weaver-smalltablet-sim #site-title{display:none;}
.weaver-phone #site-title{display:block;}
#site-description{display:none;}\n");
    }
    if (weaverii_getopt('wii_hide_site_title_mobile')) {
	weaverii_f_write($sout,
"@media only screen and (max-width: 580px) {#site-title{display:none;}}
.weaver-phone #site-title{display:none;}\n");
    }
    if (weaverii_getopt('wii_desc_show_mobile')) {
	weaverii_f_write($sout,
"@media only screen and (max-width: 580px) {#site-description{display:block;}}
.weaver-phone #site-description{display:block;}\n");
    }

// ================================ PRO AREAS ===================================

    weaverii_pro_output_style($sout);

    weaverii_mobile_output_style($sout);


   $add_css = weaverii_getopt('wii_add_css');

    if (!empty($add_css))
	weaverii_f_write($sout, apply_filters('weaverii_css',$add_css) );

    weaverii_f_write($sout, "\n/* end Weaver II CSS */\n");

// ================================ DIAGNOSTICS - LAST ===================================

/*
	if (($val = weaverii_getopt('idxxxx')) != '') {		// idxxxx
	    weaverii_f_write($sout,sprintf("code\n",$val));
	}
*/
}

// ================================ MOBILE CODE ===================================
function weaverii_mobile_output_style($sout) {

    weaverii_f_write($sout,"/* Weaver II Mobile Device Options */\n");

    if ( weaverii_smart_mode() ) {

// settable options
	if (($opt = weaverii_getopt('wii_mobile_title_color'))) {
	weaverii_f_write($sout,sprintf(".weaver-mobile #site-title a {color:$opt;}\n"),$opt);
	}

	if (!weaverii_getopt_checked('wii_mobile_nounderline')) {
	    $dev = '.weaver-mobile ';
	    if (!weaverii_getopt_checked('wii_mobile_tablet_nounderline'))
		$dev = '.weaver-any-mobile ';

	    weaverii_f_write($sout,sprintf(
"$dev #main a, $dev #mobile-widget-area a, $dev .sidebar_top a, $dev .sidebar_bottom a, $dev .sidebar_extra a {text-decoration: underline !important;}\n",$dev,$dev,$dev,$dev,$dev));
	}
    }

    if (weaverii_getopt('wii_mobile_hide_menu_extras')) {
	weaverii_f_write($sout,".menu-vertical .menu-add{display:none !important;}\n");
    }

    if (weaverii_getopt('wii_mobile_slide_threshold') >= 5000)	/* reduces flash of standard menu */
	weaverii_f_write($sout,"#nav-bottom-menu,#nav-top-menu {display:none;}
#mobile-bottom-nav,#mobile-top-nav {display:block;}\n");

    // ------ Tablet -----------
    weaverii_f_write($sout,
	"@media only screen and (max-width:768px) and (orientation:portrait) {\n");
    if (!weaverii_getopt_checked('wii_mobile_keep_site_margins')) {
	weaverii_f_write($sout,
	    "body {padding: 0px !important;}\n");
    }
    weaverii_f_write($sout,"}\n");
    weaverii_f_write($sout,
	"@media only screen and (max-width:768px) {\n");
    for ($i = 1; $i <= weaverii_pro_getopt('slider_number_sliders') ; $i++) {
	if (weaverii_pro_getopt('slider' . $i . '_hidemobile')) {
	    weaverii_f_write($sout,'#weaver-slider' . $i . "{display:none !important;}\n");
	    }
    }
    weaverii_f_write($sout,"}\n");

    // ----- Mobile - Small Tablets + Phones
    weaverii_f_write($sout,"@media only screen and (max-width:640px) {\n");	// @media

	if (weaverii_getopt_checked('wii_mobile_hide_header_image'))
	    weaverii_f_write($sout,"#header_image {display:none;}\n");

	if (weaverii_getopt_checked('_wii_hdr_widg_hide_mobile'))
	weaverii_f_write($sout,"#sidebar_header {display:none;}\n");

	weaverii_css_style_val($sout, 'body', '{font-size:%dpx !important;}',
			   'wii_site_fontsize_mobile_int');

	if (!weaverii_getopt_checked('wii_mobile_nounderline'))
	    weaverii_f_write($sout,
    "#main a, #mobile-widget-area a, .sidebar_top a, .sidebar_bottom a, .sidebar_extra a{text-decoration: underline !important;}\n");

	if (($opt = weaverii_getopt('wii_mobile_title_color')))
	    weaverii_f_write($sout,sprintf("#site-title a {color:$opt;}\n"),$opt);

	if (weaverii_getopt_checked('wii_mobile_show_footerwidgets'))
	    weaverii_f_write($sout,".weaver-mobile-resp-nostack #sidebar_wrap_footer {display:block;}\n");

	if (weaverii_getopt_checked('wii_mobile_hide_topbottom_widgets'))
	    weaverii_f_write($sout,".sidebar_top, .sidebar_bottom {display:none;}\n");

    weaverii_f_write($sout,"}\n");				// end @media

    // ----- Phones

    weaverii_f_write($sout,"@media only screen and (max-width: 580px) {\n");

	if (weaverii_getopt_checked('wii_desc_show_mobile'))
	    weaverii_f_write($sout,"#site-description {display:block;}\n");

    weaverii_f_write($sout,"}\n");
}

function weaverii_css_style($sout, $name, $style) {
    /* output a css rule style (include {}'s in style) */
    if ($style == '' || !$name)
	return;
    weaverii_f_write($sout, "$name $style\n");
}

function weaverii_css_style_val($sout, $name, $style, $opt) {
    /* output a css rule style with one value (include {}'s in style) */
    $val = weaverii_getopt($opt);
    if ($val == '' || $val === false || !$style || !$name)
	return;
    weaverii_f_write($sout, sprintf("$name $style\n",$val));
}

function weaverii_css_color($sout, $name, $color) {
    /* output a CSS color rule */
    if ($color == '' || !$name)
	return;
    weaverii_f_write($sout, "$name {color: $color;}\n");
}

function weaverii_css_css($sout, $name, $opt) {
    /* output a CSS css rule */
    $style = weaverii_getopt($opt);
    if ($style == ''  || $style === false || !$name)
	return;
    weaverii_f_write($sout, "$name" . apply_filters('weaverii_css',$style) . "\n");
}

function weaverii_put_link($sout,$id, $a, $avisited, $ahover) {
    weaverii_put_color($sout,$id.'_color',$a);
    weaverii_put_color($sout,$id.'_visited_color',$avisited);
    weaverii_put_color($sout,$id.'_hover_color',$ahover);

    $link_u = weaverii_getopt_checked('wii_link_u');	// always fetch standard link attributes
    $link_em = weaverii_getopt_checked('wii_link_em');
    $link_strong = weaverii_getopt_checked('wii_link_strong');
    if ($id == 'wii_link') {
	weaverii_put_rule_if_checked($sout,'wii_link_u',$ahover . '{text-decoration:underline;}');
	weaverii_put_rule_if_checked($sout,'wii_link_em',$a.'{font-style:italic;}');
	weaverii_put_rule_if_checked($sout,'wii_link_strong',$a . '{font-weight:bold;}');
    } else {
	$def_u = weaverii_getopt_checked($id.'_u');
	$def_em = weaverii_getopt_checked($id.'_em');
	$def_strong = weaverii_getopt_checked($id.'_strong');
	if ($link_u)
	    weaverii_put_rule_if_not_checked($sout,$id.'_u',$ahover . '{text-decoration:none;}');
	else
	    weaverii_put_rule_if_checked($sout,$id.'_u',$ahover . '{text-decoration:underline;}');
	if ($link_em)
	    weaverii_put_rule_if_not_checked($sout,$id.'_em',$a.'{font-style:normal;}');
	else
	    weaverii_put_rule_if_checked($sout,$id.'_em',$a.'{font-style:italic;}');
	if ($link_strong)
	    weaverii_put_rule_if_not_checked($sout,$id.'_strong',$a . '{font-weight:normal;}');
	else
	    weaverii_put_rule_if_checked($sout,$id.'_strong',$a . '{font-weight:bold;}');
    }
}

function weaverii_put_bgcolor($sout, $id, $tag) {
    // put bgcolor and CSS+

    if (($color = weaverii_getopt($id))) {
	if (strpos($color,'rgba') === false) {	// regular color
	    weaverii_f_write($sout, sprintf("$tag {background-color:$color;}\n"));
	} else {	// rgba - so create IE8 compatible version as well

	    // reset background for IE
	    $bgcss = 'background:transparent;'."\n";

	    $argb = weaverii_rgba2argb($color);

	    $split = explode(',', $tag);
	    $ie8 = ''; $ie7 = '';
	    foreach ($split as $id) {
		if ($ie8 != '') {
		    $ie8 .= ',';
		    $ie7 .= ',';
		}
		$ie8 .= '#ie8 ' . $id;
		$ie7 .= '#ie7 ' . $id;
	    }

	    // Filters for IE:
	    $bgcss .= '-ms-filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='.$argb.',endColorstr='.$argb.');'."\n";
	    $bgcss .= 'filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='.$argb.',endColorstr='.$argb.');'."\n";
	    $bgcss .= 'zoom:1 !important;';
	    weaverii_f_write($sout, sprintf("$ie7,\n$ie8 { $bgcss }\n"));
	    weaverii_f_write($sout, sprintf("$tag {background-color:$color;}\n"));	// the standard value
	}
    }

    if (($style = weaverii_getopt($id . '_css')) ) {
	weaverii_f_write($sout, apply_filters('weaverii_css', sprintf("%s %s\n",$tag,$style)));
    }
}

function weaverii_rgba2argb($rgba_in) {
    // convert rgba(1,2,3,.4) to #aarrggbb
    if (strpos($rgba_in,'rgba') === false) return $rgba_in;
    $rgb = $rgba_in;
    $rgb = str_replace('rgba','',$rgb);	// eliminate the rgba() and spaces
    $rgb = str_replace('(','',$rgb);
    $rgb = str_replace(')','',$rgb);
    $rgb = str_replace(' ','',$rgb);

    list($r,$g,$b,$a) = explode(',',$rgb);	// retrieve the rgba values
    $a = intval($a * 255.);
    $r = intval($r);
    $g = intval($g);
    $b = intval($b);
    $hex = "#";
    $hex .= str_pad(dechex($a), 2, "0", STR_PAD_LEFT);
    $hex .= str_pad(dechex($r), 2, "0", STR_PAD_LEFT);
    $hex .= str_pad(dechex($g), 2, "0", STR_PAD_LEFT);
    $hex .= str_pad(dechex($b), 2, "0", STR_PAD_LEFT);
    return $hex;
}

function weaverii_put_color($sout, $id, $tag, $important=false) {
    // put color and CSS+

    if (($color = weaverii_getopt($id))) {
	if ($important)
	weaverii_f_write($sout, sprintf("$tag {color:$color !important;}\n"));
	else
	    weaverii_f_write($sout, sprintf("$tag {color:$color;}\n"));
    }

    if (($style = weaverii_getopt($id . '_css')) ) {
	weaverii_f_write($sout, apply_filters('weaverii_css', sprintf("%s %s\n",$tag,$style)));
    }
}

function weaverii_put_rule_if_checked($sout, $id, $rule) {
    // put just a rule if checked

    if (weaverii_getopt_checked($id)) {
	weaverii_f_write($sout, $rule . "\n");
    }
}

function weaverii_put_rule_if_not_checked($sout, $id, $rule) {
    // put just a rule if not checked

    if (!weaverii_getopt_checked($id)) {
	weaverii_f_write($sout, $rule . "\n");
    }
}



?>
